" Unit 3 - Lecture 3 "
"------------------------------------------------------------------------"

" Hypothesis Testing "

"
Case 1:
One Population Mean Test
"
"
Hypothesis:

H0: Mu = Mu_0 v/s H1: Mu <>!= Mu_0

Define: alpha

Under H0,
TS: (x_bar - Mu_0) / S.E(x_bar)

DC: Compare Tab and Calculated value
Reject H0 if p-value < alpha


1.) Xi ~ N
2.) SD is unknown

"

# Syntax:
t.test(x = ,y = ,alternative = ,
       conf.level = ,
       mu = ,var.equal = ,paired = )

"
Claims from a Motor Insurance Portfolio is
given below:
23085, 24143, 22156, 19079, 23874, 
27207, 23003, 26972, 24740, 22247

Test whether the mean claim amount is 10,000.

"

# Manual
# H0: Mu = 10,000 v/s H1: Mu != 10,000

# alpha = 5%

# T.S
alpha = 0.05

X = c(23085,24143,22156,19079,23874, 
      27207,23003,26972,24740,22247)

T.CAL = 
  (mean(X) - 10000) / 
  (sqrt(var(X) / length(X)))

T.TAB = qt(alpha / 2,length(X) - 1,
           lower.tail = F)

abs(T.CAL) > T.TAB


# Using Function

t.test(X,mu = 10000)

 
qqnorm(X)
qqline(X,col = "red")


"------------------------------------------------------------------------"

"
Case 2:
Two Population Mean Test
"
"
Hypothesis:

H0: Mu_1 = Mu_2 v/s H1: Mu_1 <>!= Mu_2

Define: alpha

Under H0,

DC: Compare Tab and Calculated value
Reject H0 if p-value < alpha


Assumptions:
1.) Xij ~ N
2.) Sigma1, Sigma2 are unknown
3.) Sigma1 = Sigma2

"

t.test(x = ,y = ,
       alternative = ,
       conf.level = ,
       var.equal = T)


"------------------------------------------------------------------------"

"
Case 3:
One Population Variance Test
"
"
Hypothesis:

H0: Sigma^2 = Sigma_0^2 v/s 
H1: Sigma^2 <>!= Sigma_0^2

Define: alpha

Under H0,
TS: (n - 1)*S^2 / Sigma_0^2

DC: Compare Tab and Calculated value
Reject H0 if p-value < alpha

"

"
Question:
In a bottle cap manf. factory,
below are the 100 values of the diameter
of the bottle cap.

Check if the S.D is more than 2 cm.
"
set.seed(10)
Cap.Diameter = rnorm(100,
                     5,
                     sample(seq(1,5,0.25),1))

# H0: Sigma^2 = 2^2
# H1: Sigma^2 > 4

# T.S
n = length(Cap.Diameter)
sigma_0 = 2
Chi.Cal = (n - 1) * var(Cap.Diameter) / 
                                sigma_0^2

Chi.Tab = qchisq(0.05,
                 n - 1,
                 lower.tail = F)

Chi.Cal > Chi.Tab
                                   

"------------------------------------------------------------------------"

" 
Case 4:
Two Population Variance "
"
Hypothesis:

H0: Sigma_1^2 = Sigma_2^2 v/s 
H1: Sigma_1^2 <>!= Sigma_2^2

Define: alpha

Under H0,
TS: S_1^2 / S_2^2

DC: Compare Tab and Calculated value
Reject H0 if p-value < alpha

"

# Syntax:
var.test(x = ,
         y = ,
         alternative = ,
         conf.level = )



"------------------------------------------------------------------------"

" Exercise "

" 
1.)
It is believed that the mean precision of an
instrument is 2.1. At 1% l.o.s, test whether
the mean precision is 2.1 or more.

Data = 2.5, 2.3, 2.4, 2.3, 2.5, 2.7,
       2.5, 2.6, 2.7, 2.7, 2.5
"

X = c(2.5, 2.3, 2.4, 2.3, 2.5, 2.7,
      2.5, 2.6, 2.7, 2.7, 2.5)

t.test(X,mu = 2.1,
       conf.level = 0.99,
       alternative = "greater")

"
2.)
Import the dataset Time Taken.csv
The dataset represents the time taken
by 2 group of students to solve a problem.
Can we conclude that both the groups have 
taken equal time on an average to solve the
problem.

"
DATA = read.csv("C:/Users/tanis/Desktop/Time Taken.csv")

t.test(DATA$JUNIOR,
       DATA$DEGREE,
       var.equal = T)

"
Since p-value < alpha, we have sufficient
evidence to Reject the H0.
Which means that the average time taken by
Junior and Degree students is not the same.
"

"
3.)
A truck firm wants to know whether they
can market their product as the best.
(Best indicates average tyre life is
than 28,000 miles)
On a sample of 40 tyres, the mean lifetime
was 27,563 miles and sd to be 1,348 miles
Conclude at 0.01 l.o.s

"


"
4.)
Ram and Karim just completed an investigation 
which required the application of a 
two - sampled t-test to compare two independent
samples each of size 11. Upon discussion, 
they found that they had missed to conduct an test to 
check their equal variance assumption 
required for this test. 

Their data was stored in vectors males and females : 
Run the below code to load them in your R session :

Males <- c(21,22,28,27,20,23,26,32,25,21,30)
Females <- c(19,18,38,33,24,39,22,29,28,26,30)

a.)
Conduct an appropriate test in R. 
Your output should contain the 
alternative hypothesis and the 
p - value for the test.


b.)
Comment on the validity of the test 
conducted by Karim prior to a.)

"

"------------------------------------------------------------------------"

"

Understand:
- Chi-Sq GoF Test
- Paired data

"
"------------------------------------------------------------------------"

"
Case 5:
Paired t-Test

"
"
Hypothesis:

H0: Diff = Del v/s H1: Diff <>!= Del

Define: alpha

Under H0,
TS: (D_Mean - Diff) / S.E(x_bar)

DC: Compare Tab and Calculated value
Reject H0 if p-value < alpha


"

"
Example:
A clinic wants to test whether there
is no difference in the diabetic
scores before and after lunch.
Conclude at 5% l.o.s "

set.seed(1101)
Before.Lunch = runif(10,150,250)
After.Lunch = Before.Lunch + runif(10,10,20)


"------------------------------------------------------------------------"
